-- Author:Miodowy
-- Name:BetterHorseValue

BetterHorseValue = {}
local modDir = g_currentModDirectory

local priceConfig = {
    buy = {
        [0] = 500,
        [36] = 10000,
        [60] = 15000
    },
    sell = {
        [0] = 450,
        [36] = 17000,
        [60] = 19000
    }
}

function BetterHorseValue:loadAnimals()
    if self.isServer then

        for _, subTypeIndex in ipairs(g_currentMission.animalSystem.nameToType['HORSE'].subTypes) do
            local subType = g_currentMission.animalSystem.subTypes[subTypeIndex]

            for _, buyPrice in ipairs(subType.buyPrice.keyframes) do
                local time = buyPrice.time
                buyPrice[1] = priceConfig.buy[time] or buyPrice[1]
                printf('-- BetterHorseValue: %s buyPrice for time:%s set to:%s', subType.name, time, buyPrice[1])
            end

            for _, sellPrice in ipairs(subType.sellPrice.keyframes) do
                local time = sellPrice.time
                sellPrice[1] = priceConfig.sell[time] or sellPrice[1]
                printf('-- BetterHorseValue: %s sellPrice for time:%s set to:%s', subType.name, time, sellPrice[1])
            end
        end
    end
end

AnimalSystem.loadAnimals = Utils.appendedFunction(AnimalSystem.loadAnimals, BetterHorseValue.loadAnimals)