require('include')
function testSlider()
    local p = Polyline({ Vertex(0, 0), Vertex(0, 5), Vertex(0, 10), Vertex(5, 10), Vertex(10, 10), Vertex(15, 10), Vertex(20, 10) })
    local s = CourseGenerator.Slider(p, 1, 0)
    s:assertAlmostEquals(CourseGenerator.LineSegment(0, 0, 0, 1))
    s = CourseGenerator.Slider(p, 1, 3)
    s:assertAlmostEquals(CourseGenerator.LineSegment(0, 3, 0, 4))
    s = CourseGenerator.Slider(p, 1, 5)
    s:assertAlmostEquals(CourseGenerator.LineSegment(0, 5, 0, 6))
    s = CourseGenerator.Slider(p, 1, 10)
    s:assertAlmostEquals(CourseGenerator.LineSegment(0, 10, 0, 11))
    s:move(6)
    s:assertAlmostEquals(CourseGenerator.LineSegment(6, 10, 7, 10))
    -- don't move past the end of the polyline
    s:move(60)
    s:assertAlmostEquals(CourseGenerator.LineSegment(20, 10, 21, 10))

    s = CourseGenerator.Slider(p, 1, -2)
    s:assertAlmostEquals(CourseGenerator.LineSegment(0, 0, 0, 1))

    s = CourseGenerator.Slider(p, 7, 0)
    s:assertAlmostEquals(CourseGenerator.LineSegment(20, 10, 21, 10))
    s:move(-2)
    s:assertAlmostEquals(CourseGenerator.LineSegment(18, 10, 19, 10))
    s:move(-10)
    s:assertAlmostEquals(CourseGenerator.LineSegment(8, 10, 9, 10))

    p = Polygon({ Vector(0, 0), Vector(0, 5), Vector(5, 5), Vector(5, 0) })
    s = CourseGenerator.Slider(p, 1, 6)
    s:assertAlmostEquals(CourseGenerator.LineSegment(1, 5, 2, 5))
    s = CourseGenerator.Slider(p, 1, -2)
    s:assertAlmostEquals(CourseGenerator.LineSegment(2, 0, 1, 0))
    -- wrap around backwards
    s = CourseGenerator.Slider(p, 1, -20)
    s:assertAlmostEquals(CourseGenerator.LineSegment(0, 0, 0, 1))
    -- wrap around forward
    s = CourseGenerator.Slider(p, 1, 20)
    -- just before the last corner
    s:assertAlmostEquals(CourseGenerator.LineSegment(0, 0, -1, 0))
    s = CourseGenerator.Slider(p, 1, 20.0001)
    s:assertAlmostEquals(CourseGenerator.LineSegment(0, 0, 0, 1))
    s:move(1)
    s:assertAlmostEquals(CourseGenerator.LineSegment(0, 1, 0, 2))
    s:move(1)
    s:assertAlmostEquals(CourseGenerator.LineSegment(0, 2, 0, 3))
    s:move(-1)
    s:assertAlmostEquals(CourseGenerator.LineSegment(0, 1, 0, 2))
    s:move(-1)
    s:assertAlmostEquals(CourseGenerator.LineSegment(0, 0, 0, 1))
end
os.exit(lu.LuaUnit.run())