AutomaticWateringSpecialization = {}

function AutomaticWateringSpecialization.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(PlaceableProductionPoint, specializations)
end

function AutomaticWateringSpecialization.registerEventListeners(placeableType)
	SpecializationUtil.registerEventListener(placeableType, "onLoad", AutomaticWateringSpecialization)
    SpecializationUtil.registerEventListener(placeableType, "onReadStream", AutomaticWateringSpecialization)
    SpecializationUtil.registerEventListener(placeableType, "onWriteStream", AutomaticWateringSpecialization)
	SpecializationUtil.registerEventListener(placeableType, "onReadUpdateStream", AutomaticWateringSpecialization)
	SpecializationUtil.registerEventListener(placeableType, "onWriteUpdateStream", AutomaticWateringSpecialization)
end

function AutomaticWateringSpecialization:onLoad(savegame)
    self.AutoWatering = false;
end

function AutomaticWateringSpecialization.registerSavegameXMLPaths(schema, basePath)
    schema:register(XMLValueType.BOOL, basePath.."#AutoWatering", "AutoWatering", false)
end

function AutomaticWateringSpecialization:saveToXMLFile(xmlFile, key, usedModNames)
    xmlFile:setBool(key.."#AutoWatering", self.AutoWatering)
end

function AutomaticWateringSpecialization:loadFromXMLFile(xmlFile, key)
    self.AutoWatering = xmlFile:getBool(key.."#AutoWatering") or false
end

function AutomaticWateringSpecialization:onReadStream(streamId, connection)
    self.AutoWatering = streamReadBool(streamId)
end

function AutomaticWateringSpecialization:onWriteStream(streamId, connection)
    streamWriteBool(streamId, self.AutoWatering)
end

function AutomaticWateringSpecialization:onReadUpdateStream(streamId, connection)
    self.AutoWatering = streamReadBool(streamId)
end

function AutomaticWateringSpecialization:onWriteUpdateStream(streamId, connection)
    streamWriteBool(streamId, self.AutoWatering)
end