WateringStateEvent = {}
WateringStateEvent_mt = Class(WateringStateEvent, Event)

InitEventClass(WateringStateEvent, "WateringStateEvent")

function WateringStateEvent.emptyNew()
    local self = Event.new(WateringStateEvent_mt)
    return self
end

function WateringStateEvent.new(OwnerPlaceable, Enable)
    local self = WateringStateEvent.emptyNew()
    self.OwnerPlaceable = OwnerPlaceable
    self.Enable = Enable

    return self
end

function WateringStateEvent:readStream(streamId, connection)
    self.OwnerPlaceable = NetworkUtil.readNodeObject(streamId)
    self.Enable = streamReadBool(streamId)

    self:run(connection)
end

function WateringStateEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.OwnerPlaceable)
	streamWriteBool(streamId, self.Enable)
end

function WateringStateEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(WateringStateEvent.new(self.OwnerPlaceable, self.Enable))
    end

    if self.OwnerPlaceable ~= nil then
        self.OwnerPlaceable.AutoWatering = self.Enable;
    end
end

function WateringStateEvent:sendEvent(OwnerPlaceable, Enable)
    if g_server ~= nil then
        g_server:broadcastEvent(WateringStateEvent.new(OwnerPlaceable, Enable))
    else
        g_client:getServerConnection():sendEvent(WateringStateEvent.new(OwnerPlaceable, Enable))
    end
end