-- ============================================================================ 
-- === CustomStoneLoader.Lua 
-- === MOD by [LSMT] Modding Team 
-- === LS25 / FS25
-- === Script by [LSMT] BaTt3RiE @ 2025 
-- === Ver 1.0.0.0
-- ============================================================================

CustomStoneLoader = {}

-- Originale Funktion speichern, bevor wir sie überschreiben
CustomStoneLoader.originalLoadMapData = StoneSystem.loadMapData

-- Überschreiben der Ladefunktion
function StoneSystem:loadMapData(xmlFile, _, baseDirectory)
    self.baseDirectory = baseDirectory
    
    -- Die Zeile, die die Default-Datei lädt, wird übersprungen
    -- self:loadStones("data/maps/maps_stones.xml")
    
    local stoneFilename = getXMLString(xmlFile, "map.stones#filename")
    if stoneFilename ~= nil then
        self:loadStones(Utils.getFilename(stoneFilename, baseDirectory))
    end
    
    if g_server ~= nil and g_addCheatCommands then
        addConsoleCommand("gsStoneSystemAddDelta", "Add stone delta to field", "consoleCommandAddDelta", self, "fieldId; [delta]")
        addConsoleCommand("gsStoneSystemSetState", "Set stone state to field", "consoleCommandSetState", self, "fieldId; state")
        addConsoleCommand("gsStoneSystemToggleDebug", "Toggles debug view", "consoleCommandToggleDebug", self)
    end
    
    return true
end

-- Debug-Ausgabe
print("CustomStoneLoader: Standardmäßige maps_stones.xml wird nicht geladen.")