-- ============================================================================ 
-- === DisableUAL.Lua 
-- === MOD my [LSMT] Modding Team 
-- === LS25 / FS25
-- === Script by [LSMT] BaTt3RiE @ 2025 
-- === Ver 1.0.0.0
-- ============================================================================

DisableUAL = {}

function DisableUAL.prerequisitesPresent(_specs)
    return true
end

function DisableUAL.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType,
                                             "onPostLoad",
                                             DisableUAL)
end

function DisableUAL:onPostLoad(_savegame)
    local ual = self.spec_universalAutoload
    if ual ~= nil then
        -- Autoload für UniversalAutoload komplett „unsichtbar“ machen
        ual.isAutoloadAvailable = false      -- ← WICHTIG!
        ual.autoloadDisabled   = true
    end
end
