-- ============================================================================
-- === StoreCategories.lua
-- === Custom Version Only für Multimap
-- === Mod by [LSMT] Modding Team
-- === LS25
-- === Script by [LSMT] BaTt3RiE @ 2025
-- === Ver 0.1.2.0 (BETA)
-- ============================================================================

loadStoreCategories = {}

local modDir = g_currentModDirectory
local modName = g_currentModName
local Name = g_i18n:getText("shopMainCategory_KartenMods")

if not g_storeManager.categoryTypesByName["MAINCATEGORY"] then
    g_storeManager:addCategoryType("MAINCATEGORY", Name)
end

if not g_storeManager.categoryTypesByName["NEWTYPEC"] then
    g_storeManager:addCategoryType("NEWTYPEC", "DUMP")
end

function loadStoreCategories.loadMapData(self, superFunc, xmlFile, missionInfo, baseDirectory)
    superFunc(self, xmlFile, missionInfo, baseDirectory)

    local modXML = XMLFile.load("ModFile", modDir .. "modDesc.xml")
    if modXML == nil then
        return true
    end

    local skipList = {
        TRAILERSEMI = true,
        TRAILER     = true,
        VEHICLE     = true
    }

    for _, key in modXML:iterator("modDesc.storeCategories.storeType") do
        local catTypeName = modXML:getString(key .. "#name")
        if catTypeName ~= nil
           and skipList[catTypeName] ~= true
           and g_storeManager.categoryTypesByName[catTypeName] == nil then
            -- Nur anlegen, wenn nicht vorhanden
            g_storeManager:loadCategoryType(modXML, key, modDir, modName)
        end
    end

    for _, key in modXML:iterator("modDesc.storeCategories.storeCategory") do
        local catName = modXML:getString(key .. "#name")
        if catName ~= nil
           and skipList[catName] ~= true then
            if g_storeManager.categoriesByName == nil
               or g_storeManager.categoriesByName[catName] == nil then
                g_storeManager:loadCategoryFromXML(modXML, key, modDir, modName)
            end
        end
    end

    local defaultRefSize = {256, 256}

    local constructionTypes = {
        {
            categoryName = "NEWTYPEC",
            title = g_i18n:getText("shopMainCategory_Mod"),
            iconFilename = modDir .. "img/mods.dds",
            refSize = {256, 256},
            iconUVs = GuiUtils.getUVs("0 0 1 1", {256, 256})
        },
    }

    for _, category in ipairs(constructionTypes) do
        if g_storeManager.constructionCategoriesByName == nil
           or g_storeManager.constructionCategoriesByName[category.categoryName] == nil then
            g_storeManager:addConstructionCategory(
                category.categoryName,
                category.title,
                category.iconFilename,
                category.iconUVs,
                "",
                iconSliceId
            )
        end
    end

    if g_storeManager.registeredConstructionTabs == nil then
        g_storeManager.registeredConstructionTabs = {}
    end

    for _, key in modXML:iterator("modDesc.constructionCategories.constructionCategory") do
        local categoryTypeName = "NEWTYPEC"
        local tabName = modXML:getString(key .. "#name")
        if tabName ~= nil
           and g_storeManager.registeredConstructionTabs[tabName] ~= true then

            local tabTitleKey = modXML:getString(key .. "#title")
            local tabTitle = g_i18n:getText(tabTitleKey)
            local tabIconFilename = modDir .. "img/hud_fill_armoire.dds"
            local tabRefSize = modXML:getVector(key .. "#refSize", defaultRefSize, 2)
            local tabIconUVs = GuiUtils.getUVs(
                modXML:getString(key .. "#iconUVs", "0 0 1 1"),
                tabRefSize
            )

            g_storeManager:addConstructionTab(
                categoryTypeName,
                tabName,
                tabTitle,
                tabIconFilename,
                tabIconUVs,
                "",
                iconSliceId
            )

            g_storeManager.registeredConstructionTabs[tabName] = true
        end
    end

    modXML:delete()
    return true
end

StoreManager.loadMapData = Utils.overwrittenFunction(
    StoreManager.loadMapData,
    loadStoreCategories.loadMapData
)