--[[
RemoveItem.lua
Removes Vanilla Items from Shop with a message. Just add the filenames(with path) to this file and load it ingame with the modDesc.

Free to use.
	
Author: 	Braeven
Date:		10.01.2023
Version:	1.1.0.0

History:	v1.0.0.0 @05.05.2022 - Initial Release
					V1.1.0.0 @10.01.2023 - Fixed a Bug with already removed Items and added the modname to the removed-message.
]]

RemoveStuff = {};

function RemoveStuff.loadMap(filename)
  StufftoRemove = {
				   "data/placeables/planET/bga99kw/bga99kw.xml",
                   "data/placeables/planET/bga250kw/bga250kw.xml",
                   "data/placeables/planET/bga500kw/bga500kw.xml",
				   
				   "data/placeables/mapEU/bakery/bakery.xml",
				   "data/placeables/mapEU/cementFactoryEU/cementFactoryPlaceable.xml",
				   "data/placeables/mapEU/dairy/dairyPlaceable.xml",
				   "data/placeables/mapEU/potatoProcessingPlant/potatoProcessingPlantPlaceable.xml",
				   "data/placeables/mapEU/preservedFoodFactory/preservedFoodFactoryPlaceable.xml",
				   "data/placeables/mapEU/soupFactory/soupFactoryPlaceable.xml",
				   "data/placeables/mapEU/spinnery/spinneryPlaceable.xml",
				   
				   "data/placeables/mapUS/bakeryUS/bakeryUS.xml",
				   "data/placeables/mapUS/cannedPackagedFactoryUS/cannedPackagedFactoryUS.xml",
				   "data/placeables/mapUS/carpenterUS/carpenterUS.xml",
				   "data/placeables/mapUS/cementFactoryUS/cementFactoryUS.xml",
				   "data/placeables/mapUS/dairyUS/dairyUS.xml",
				   "data/placeables/mapUS/grainFlourMillUS/grainFlourMillUS.xml",
				   "data/placeables/mapUS/oilPlantUS/oilPlantUS.xml",
				   "data/placeables/mapUS/paperMill/paperMill.xml",
				   "data/placeables/mapUS/ropeMakerUS/ropeMakerUS.xml",
				   "data/placeables/mapUS/sawmillUS/sawmillUS.xml",
				   "data/placeables/mapUS/spinnery/spinneryUS.xml",
				   "data/placeables/mapUS/tailorUS/tailorUS.xml",
				   "data/placeables/mapUS/warehouseLogisticUS/warehouseLogisticUS.xml",
				   
				   
				   "data/placeables/brandless/greenhouses/greenHouseGlass/greenHouseGlassLarge.xml",
				   "data/placeables/brandless/greenhouses/greenHouseGlass/greenHouseGlassMedium.xml",
				   "data/placeables/brandless/greenhouses/greenHouseGlass/greenHouseGlassSmall.xml",
				   "data/placeables/brandless/greenhouses/greenHouseMushrooms/greenHouseMushroomsLarge.xml",
				   "data/placeables/brandless/greenhouses/greenHouseMushrooms/greenHouseMushroomsMedium.xml",
				   "data/placeables/brandless/greenhouses/greenHouseMushrooms/greenHouseMushroomsSmall.xml",
				   "data/placeables/brandless/greenhouses/greenHousesTarp/greenHousesTarpLarge.xml",
				   "data/placeables/brandless/greenhouses/greenHousesTarp/greenHousesTarpMedium.xml",
				   "data/placeables/brandless/greenhouses/greenHousesTarp/greenHousesTarpSmall.xml",
				   
				   "data/placeables/brandless/productionPointsGeneric/bakery/bakery.xml",
				   "data/placeables/brandless/productionPointsGeneric/carpentry/carpentry.xml",
				   "data/placeables/brandless/productionPointsGeneric/dairy/dairy.xml",
				   "data/placeables/brandless/productionPointsGeneric/grainMill/grainMill.xml",
				   "data/placeables/brandless/productionPointsGeneric/oilMill/oilMill.xml",
				   "data/placeables/brandless/productionPointsGeneric/paperFactory/paperFactory.xml",
				   "data/placeables/brandless/productionPointsGeneric/sawmill/sawmill.xml",
				   "data/placeables/brandless/productionPointsGeneric/sawmillPlaceable/sawmillPlaceable.xml",
				   "data/placeables/brandless/productionPointsGeneric/spinnery/spinnery.xml",

				   "data/placeables/brandless/productionPointsGeneric/sugarMill/sugarMill.xml",
				   "data/placeables/brandless/productionPointsGeneric/tailorShop/tailorShop.xml",
				   
				   "data/placeables/brandless/productionPointsSmall/bakery/bakery.xml",
				   "data/placeables/brandless/productionPointsSmall/biomassHeatingPlant/biomassHeatingPlant.xml",
				   "data/placeables/brandless/productionPointsSmall/cannedPackagedFactory/cannedPackagedFactory.xml",
				   "data/placeables/brandless/productionPointsSmall/carpenter/carpenter.xml",
				   "data/placeables/brandless/productionPointsSmall/cementFactory/cementFactory.xml",
				   "data/placeables/brandless/productionPointsSmall/dairy/dairy.xml",
				   "data/placeables/brandless/productionPointsSmall/debrisCrusher/debrisCrusher.xml",
				   "data/placeables/brandless/productionPointsSmall/grainFlourMill/grainFlourMill.xml",
				   "data/placeables/brandless/productionPointsSmall/grapeProcessingPlant/grapeProcessingPlant.xml",
				   "data/placeables/brandless/productionPointsSmall/oilPlant/oilPlant.xml",
				   "data/placeables/brandless/productionPointsSmall/sawmill/sawmill.xml",
				   "data/placeables/brandless/productionPointsSmall/spinnery/spinnery.xml",
				   "data/placeables/brandless/productionPointsSmall/sugarMill/sugarMill.xml",
				   "data/placeables/brandless/productionPointsSmall/tailorShop/tailorShop.xml",
				   
				   "data/vehicles/fliegl/noahTTW140/noahTTW140.xml"
				   
				   
				   
				   
				   
				   
				   
				   
				   };
	for _, xmlFilename in pairs(StufftoRemove) do
    local removed = g_storeManager:getItemByXMLFilename(xmlFilename)
    if removed == nil then
      print("Can't remove: '" .. tostring(xmlFilename) .. "' from Shop, does not exist or was removed before.")
    else
      g_storeManager:removeItemByIndex(removed.id)
		  print("Removed: '" .. tostring(xmlFilename) .. "' from Shop.")
    end
  end
end

addModEventListener(RemoveStuff);