--[[
Part of Production Storage Control FS25

Copyright (C) braeven 2025

Author: braeven

Important:
No modifications to this script are permitted without Braeven's permission.
You are not allowed to use part of this script without permission.
]]
productionStorageControl_EventSpawn = {}
local productionStorageControl_EventSpawn_mt = Class(productionStorageControl_EventSpawn, Event)
InitEventClass(productionStorageControl_EventSpawn, "productionStorageControl_EventSpawn")

function productionStorageControl_EventSpawn.emptyNew()
	return Event.new(productionStorageControl_EventSpawn_mt)
end

function productionStorageControl_EventSpawn.new(productionPoint, ownerFarmId, fillTypeIndex, pendingLiters, width, height, length, capacity, type, customEnvironment, treeId, amount, color1, color2, color3)
	local self = productionStorageControl_EventSpawn.emptyNew()
	self.productionPoint = productionPoint
	self.ownerFarmId = ownerFarmId
	self.fillTypeIndex = fillTypeIndex
	self.pendingLiters = pendingLiters
	self.width = width
	self.height = height
	self.length = length
	self.capacity = capacity
	self.type = type
	self.customEnvironment = customEnvironment
	self.treeId = treeId
	self.amount = amount
	self.color1 = color1
	self.color2 = color2
	self.color3 = color3

	return self
end

function productionStorageControl_EventSpawn:readStream(streamId, connection)
	self.productionPoint = NetworkUtil.readNodeObject(streamId)
	self.ownerFarmId = streamReadInt32(streamId)
	self.fillTypeIndex = streamReadInt32(streamId)
	self.pendingLiters = streamReadInt32(streamId)
	self.width = streamReadFloat32(streamId)
	self.height = streamReadFloat32(streamId)
	self.length = streamReadFloat32(streamId)
	self.capacity = streamReadFloat32(streamId)
	self.type = streamReadFloat32(streamId)
	if streamReadBool(streamId) then
		self.customEnvironment = streamReadString(streamId)
	end
	if streamReadBool(streamId) then
		self.treeId = streamReadInt32(streamId)
	end
	self.amount = streamReadFloat32(streamId)
	self.color1 = streamReadFloat32(streamId)
	self.color2 = streamReadFloat32(streamId)
	self.color3 = streamReadFloat32(streamId)

	self:run(connection)
end

function productionStorageControl_EventSpawn:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.productionPoint) 
	streamWriteInt32(streamId, self.ownerFarmId)
	streamWriteInt32(streamId, self.fillTypeIndex)
	streamWriteInt32(streamId, self.pendingLiters)
	streamWriteFloat32(streamId, self.width)
	streamWriteFloat32(streamId, self.height)
	streamWriteFloat32(streamId, self.length)
	streamWriteFloat32(streamId, self.capacity)
	streamWriteFloat32(streamId, self.type)
	if streamWriteBool(streamId, self.customEnvironment ~= nil) then
		streamWriteString(streamId, self.customEnvironment)
	end
	if streamWriteBool(streamId, self.treeId ~= nil) then
		streamWriteInt32(streamId, self.treeId)
	end
	streamWriteFloat32(streamId, self.amount)
	streamWriteFloat32(streamId, self.color1)
	streamWriteFloat32(streamId, self.color2)
	streamWriteFloat32(streamId, self.color3)
end

function productionStorageControl_EventSpawn:run(connection)
	self.productionPoint:ReceiveSpawnEvent(self.ownerFarmId, self.fillTypeIndex, self.pendingLiters, self.width, self.height, self.length, self.capacity, self.type, self.customEnvironment, self.treeId, self.amount, self.color1, self.color2, self.color3)
end

function productionStorageControl_EventSpawn.sendEvent(productionPoint, ownerFarmId, fillTypeIndex, pendingLiters, width, height, length, capacity, type, customEnvironment, treeId, amount, color1, color2, color3)
	g_client:getServerConnection():sendEvent(productionStorageControl_EventSpawn.new(productionPoint, ownerFarmId, fillTypeIndex, pendingLiters, width, height, length, capacity, type, customEnvironment, treeId, amount, color1, color2, color3))
end