--
-- MobileWorkshop
--
-- @author Rockstar
-- @date 30/11/2024
--


MobileWorkshop = {}

function MobileWorkshop:init()
	self.vehicle = nil
	self.interactText = ""

	self.activateWorkshopEventId = nil

	self.isDealer = false
	self.isOwnWorkshop = false
	self.isMobileWorkshop = true

	if InputHelpDisplay.MAX_NUM_ELEMENTS <= 6 then
		InputHelpDisplay.MAX_NUM_ELEMENTS = 10
	end

	MobileWorkshopUtil.appendedFunction(PlayerInputComponent, "update", self, "playerInputComponent_update", false)
	MobileWorkshopUtil.appendedFunction(PlayerInputComponent, "registerActionEvents", self, "playerInputComponent_registerActionEvents", false)
end

function MobileWorkshop:getIsValidVehicle(vehicle, farmId)
	return vehicle:getShowInVehiclesOverview() and vehicle:getOwnerFarmId() == farmId
end

function MobileWorkshop:onInputActivateWorkshop()
	local vehicle = self.vehicle

	if vehicle ~= nil then
		local vehicles = {}

		for _, subVehicle in ipairs(vehicle.rootVehicle:getChildVehicles()) do
			if self:getIsValidVehicle(subVehicle, g_currentMission:getFarmId()) then
				table.addElement(vehicles, subVehicle)
			end
		end

		table.sort(vehicles, function (a, b)
			return a.rootNode < b.rootNode
		end)

		g_workshopScreen:setSellingPoint(nil, self.isDealer, self.isOwnWorkshop, self.isMobileWorkshop)
		g_workshopScreen:setVehicles(vehicles)
		g_workshopScreen.list:setSelectedIndex(table.find(vehicles, vehicle))
		g_gui:showGui("WorkshopScreen")
	end
end

function MobileWorkshop:playerInputComponent_update(inputComponent, dt)
	if inputComponent.player.isOwner and g_inputBinding:getContextName() == PlayerInputComponent.INPUT_CONTEXT_NAME and self.activateWorkshopEventId ~= nil then
		self.vehicle = nil
		self.interactText = ""

		local playerFarmId = g_currentMission:getFarmId()

		if playerFarmId ~= FarmManager.SPECTATOR_FARM_ID then
			local targetNode = inputComponent.player.targeter:getClosestTargetedNodeFromType(PlayerInputComponent)

			if targetNode ~= nil and entityExists(targetNode) then
				local nodeObject = g_currentMission:getNodeObject(targetNode)

				if nodeObject ~= nil and nodeObject:isa(Vehicle) and self:getIsValidVehicle(nodeObject, playerFarmId) then
					self.vehicle = nodeObject
					self.interactText = string.format("%s: %s", g_i18n:getText("action_configSellSpecificVehicle"), nodeObject:getFullName())
				end
			end
		end

		g_inputBinding:setActionEventActive(self.activateWorkshopEventId, self.vehicle ~= nil)
		g_inputBinding:setActionEventText(self.activateWorkshopEventId, self.interactText)
	end
end

function MobileWorkshop:playerInputComponent_registerActionEvents(inputComponent)
	if inputComponent.player.isOwner then
		g_inputBinding:beginActionEventsModification(PlayerInputComponent.INPUT_CONTEXT_NAME)

		local _, activateWorkshopEventId = g_inputBinding:registerActionEvent(InputAction.ACTIVATE_WORKSHOP, self, self.onInputActivateWorkshop, false, true, false, false, nil, true)

		self.activateWorkshopEventId = activateWorkshopEventId
		g_inputBinding:endActionEventsModification()
	end
end

MobileWorkshop:init()